<?php

declare (strict_types=1);
namespace RectorPrefix202208\Symplify\EasyTesting\Finder;

use RectorPrefix202208\Symfony\Component\Finder\Finder;
use RectorPrefix202208\Symplify\SmartFileSystem\Finder\FinderSanitizer;
use RectorPrefix202208\Symplify\SmartFileSystem\SmartFileInfo;
final class FixtureFinder
{
    /**
     * @var \Symplify\SmartFileSystem\Finder\FinderSanitizer
     */
    private $finderSanitizer;
    public function __construct(FinderSanitizer $finderSanitizer)
    {
        $this->finderSanitizer = $finderSanitizer;
    }
    /**
     * @param string[] $sources
     * @return SmartFileInfo[]
     */
    public function find(array $sources) : array
    {
        $finder = new Finder();
        $finder->files()->in($sources)->name('*.php.inc')->path('Fixture')->sortByName();
        return $this->finderSanitizer->sanitize($finder);
    }
}
