<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Document;

class GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeProperty extends \Google\Model
{
  /**
   * @var string
   */
  public $description;
  /**
   * @var string
   */
  public $displayName;
  /**
   * @var string
   */
  public $method;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $occurrenceType;
  protected $propertyMetadataType = GoogleCloudDocumentaiUiv1beta3PropertyMetadata::class;
  protected $propertyMetadataDataType = '';
  /**
   * @var string
   */
  public $valueType;

  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param string
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * @param string
   */
  public function setMethod($method)
  {
    $this->method = $method;
  }
  /**
   * @return string
   */
  public function getMethod()
  {
    return $this->method;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setOccurrenceType($occurrenceType)
  {
    $this->occurrenceType = $occurrenceType;
  }
  /**
   * @return string
   */
  public function getOccurrenceType()
  {
    return $this->occurrenceType;
  }
  /**
   * @param GoogleCloudDocumentaiUiv1beta3PropertyMetadata
   */
  public function setPropertyMetadata(GoogleCloudDocumentaiUiv1beta3PropertyMetadata $propertyMetadata)
  {
    $this->propertyMetadata = $propertyMetadata;
  }
  /**
   * @return GoogleCloudDocumentaiUiv1beta3PropertyMetadata
   */
  public function getPropertyMetadata()
  {
    return $this->propertyMetadata;
  }
  /**
   * @param string
   */
  public function setValueType($valueType)
  {
    $this->valueType = $valueType;
  }
  /**
   * @return string
   */
  public function getValueType()
  {
    return $this->valueType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeProperty::class, 'Google_Service_Document_GoogleCloudDocumentaiUiv1beta3DocumentSchemaEntityTypeProperty');
