import {appQueries} from '@app/app-queries';
import {apiClient, queryClient} from '@common/http/query-client';
import {showHttpErrorToast} from '@common/http/show-http-error-toast';
import {useMutation} from '@tanstack/react-query';
import {message} from '@ui/i18n/message';
import {FetchShareableLinkResponse} from './use-entry-shareable-link';

function createShareableLink(
  entryId?: number | null,
): Promise<FetchShareableLinkResponse> {
  if (!entryId) {
    return Promise.reject(new Error('Invalid entry id'));
  }
  return apiClient
    .post(`file-entries/${entryId}/shareable-link`)
    .then(response => response.data);
}

interface Payload {
  entryId: number;
}
export function useCreateShareableLink() {
  return useMutation({
    mutationFn: ({entryId}: Payload) => createShareableLink(entryId),
    onSuccess: (data, {entryId}) => {
      queryClient.setQueryData<FetchShareableLinkResponse>(
        appQueries.shareableLinks.getEntryShareableLink(entryId).queryKey,
        data,
      );
    },
    onError: err => showHttpErrorToast(err, message('Could not create link')),
  });
}
