import { useFileEntryUrls } from '../../../file-entry-urls';
import { useTrans } from '@ui/i18n/use-trans';
import { FilePreviewProps } from './file-preview-props';
import { DefaultFilePreview } from './default-file-preview';

export function ImageFilePreview(props: FilePreviewProps) {
  const { entry, className } = props;
  const { trans } = useTrans();

  // Check if this is a HEIC/HEIF file
  const isHeicFile = entry.extension &&
    (entry.extension.toLowerCase() === 'heic' || entry.extension.toLowerCase() === 'heif');

  // For HEIC files, we don't use thumbnails in preview - we want the full converted image
  // The server will handle the conversion via HeicFileResponse
  const { previewUrl } = useFileEntryUrls(entry);

  if (!previewUrl) {
    return <DefaultFilePreview {...props} />;
  }

  return (
    <img
      className={`${className || ''} shadow`}
      src={previewUrl}
      alt={trans({
        message: 'Preview for :name',
        values: { name: entry.name },
      })}
    />
  );
}